﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Magazyny" %>
<%@ import Namespace="Soneta.CRM" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Towary" %>
<%@ import Namespace="System.Collections.Generic" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Raport marży</title>
		<meta content="C#" name="CODE_LANGUAGE" />
		<meta content="JavaScript" name="vs_defaultClientScript" />
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
	</head>
    <script runat="server">
        public enum SortowanieWedług { WgKoduKontrahenta, WgNazwyKontrahenta, WgWartościMalejąco }

        public class ParametryContext : ContextBase {
            public ParametryContext(Context cx)
                : base(cx) {
            }

            SortowanieWedług sortujWedług = SortowanieWedług.WgNazwyKontrahenta;

            [DefaultWidth(50)]
            [Priority(10)]
            public SortowanieWedług SortujWedług {
                get { return sortujWedług; }
                set {
                    sortujWedług = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            int pierwszych = 0;

            [Priority(20)]
            public int Pierwszych {
                get { return pierwszych; }
                set { pierwszych = value; }
            }

			public bool IsReadOnlyPierwszych()
			{
				return SortujWedług != SortowanieWedług.WgWartościMalejąco;
			}

			private bool _ignorujZakliczkowe = false;
			[Soneta.Tools.Priority(30)]
			[Soneta.Types.Caption(@"Ignoruj zaliczkowe")]
			public bool IgnorujZaliczkowe
			{
				get
				{
					return this._ignorujZakliczkowe;
				}
				set
				{
					this._ignorujZakliczkowe = value;
					OnChanged(EventArgs.Empty);
				}
			}

			[Soneta.Tools.Priority(40)]
			public bool IgnorujDuplikaty
			{
				get
				{
					return true;
				}
			}

			[Soneta.Tools.Priority(50)]
			[Caption("Korekty kosztu (KWPZ)")]
			public bool RaportowacKwpz
			{
				get
				{
					return true;
				}
			}

            internal bool WliczKWPZ {
                get {
                    return false;
                }
            }

        }

        static ParametryContext parametry;

        [Context]
        public static ParametryContext Parametry {
            get { return parametry; }
            set { parametry = value; }
        }

        public class Total {
            readonly Kontrahent kontrahent;
            decimal znetto;
            decimal snetto;
            decimal zysk;

            public Total(Kontrahent kontrahent) {
                this.kontrahent = kontrahent;
            }

            public Percent NarzutProcent(decimal marża, decimal wartośćZakupu) {
                if (Soneta.Tools.Math.IsBlank(wartośćZakupu)) return Percent.Blank;
                if (wartośćZakupu == 0) return Percent.Blank;
                if (wartośćZakupu < 0) return new Percent((marża / wartośćZakupu) * (-1));
                return new Percent(marża / wartośćZakupu);
            }

            public Percent MarżaProcent(decimal marża, decimal wartośćZakupu) {
                if (Soneta.Tools.Math.IsBlank(wartośćZakupu)) return Percent.Blank;
                if (wartośćZakupu + marża == 0) return Percent.Blank;
                if (wartośćZakupu + marża < 0) return new Percent((marża / (wartośćZakupu + marża)) * (-1));
                return new Percent(marża / (wartośćZakupu + marża));
            }

            public void Add(DokumentHandlowy dokument, ObrotyDokumentuWorker odw) {
                decimal z = 0m;
                if (Parametry.WliczKWPZ) {
                    foreach (DokumentHandlowy dokm in dokument.DokumentyMagazynowe)
                        foreach (RelacjaHandlowa relm in dokm.PodrzedneRelacje)
                            if (relm.Typ == TypRelacjiHandlowej.KorektaPWZ) {
                                z += relm.Podrzedny.WartośćWCenieZakupu;
                            }
                }
                z += odw.WartośćZakupu;
                decimal s = odw.WartośćSprzedaży;
                znetto += z;
				snetto += s;
				zysk += s-z;
            }

            internal void AddKwpz(DokumentHandlowy dokument) {
                znetto += dokument.WartośćWCenieZakupu;
				zysk = snetto-znetto;
            }

            public Kontrahent Kontrahent {
                get { return kontrahent; }
            }

            public decimal ZNetto {
                get { return znetto; }
            }

            public decimal SNetto {
                get { return snetto; }
            }

            public decimal Zysk {
                get { return zysk; }
            }

            public Percent NarzutProc {
                get {
                    if (znetto == 0) return Percent.Blank;
                    else
                        return new Percent(zysk / znetto);
                }

            }

            public Percent MarzaProc {
                get {
                    if (snetto == 0) return Percent.Blank;
                    else
                        return new Percent(zysk / snetto);
                }
            }

        }

        class NazwaComparer : IComparer {
            public int Compare(object obj1, object obj2) {
                Total t1 = (Total)obj1;
                Total t2 = (Total)obj2;
                string s1 = t1.Kontrahent == null ? "" : t1.Kontrahent.Nazwa;
                string s2 = t2.Kontrahent == null ? "" : t2.Kontrahent.Nazwa;
                return s1.CompareTo(s2);
            }
        }

        class KodComparer : IComparer {
            public int Compare(object obj1, object obj2) {
                Total t1 = (Total)obj1;
                Total t2 = (Total)obj2;
                string s1 = t1.Kontrahent == null ? "" : t1.Kontrahent.Kod;
                string s2 = t2.Kontrahent == null ? "" : t2.Kontrahent.Kod;
                return s1.CompareTo(s2);
            }
        }

        class WartośćComparer : IComparer {
            public int Compare(object obj1, object obj2) {
                Total t1 = (Total)obj1;
                Total t2 = (Total)obj2;
                if (t1.ZNetto < t2.ZNetto) return 1;
                if (t1.ZNetto > t2.ZNetto) return -1;
                return 0;
            }
        }

        Row[] rows;
        protected void dc_ContextLoad(object sender, EventArgs e) {

            ObrotyDokumentuWorker odw = new ObrotyDokumentuWorker();
            odw.IgnorujZaliczkowe = Parametry.IgnorujZaliczkowe;
            rows = (Row[])dc[typeof(Row[])];
            ListWithView lwv = new ListWithView(rows, HandelModule.GetInstance(dc.Session).DokHandlowe.WgDaty);

            Dictionary<Kontrahent, Total> result = new Dictionary<Kontrahent, Total>();

            foreach (DokumentHandlowy dokh in lwv) {
                odw.Dokument = dokh;
				if (odw.Dokument.Anulowany) continue;
                if (odw.Dokument.Definicja.DuplikatWartosci) continue;
                if (odw.Dokument.Kontrahent == null) continue;
                System.Diagnostics.Trace.WriteLine(dokh, "Progress");
                Total t = null;
                result.TryGetValue(odw.Dokument.Kontrahent, out t);
                if (t == null) {
                    t = new Total(odw.Dokument.Kontrahent);
                    result.Add(t.Kontrahent, t);
                }
                t.Add(odw.Dokument, odw);
            }

			if (Parametry.RaportowacKwpz)
			{
				this.LoadKWPZ( result );
			}

            ArrayList lista = new ArrayList(result.Values);
            switch (Parametry.SortujWedług) {
                case SortowanieWedług.WgKoduKontrahenta:
                    lista.Sort(new KodComparer());
                    break;
                case SortowanieWedług.WgNazwyKontrahenta:
                    lista.Sort(new NazwaComparer());
                    break;
                case SortowanieWedług.WgWartościMalejąco:
                    lista.Sort(new WartośćComparer());
                    if (Parametry.Pierwszych > 0 && lista.Count > Parametry.Pierwszych)
                        lista.RemoveRange(Parametry.Pierwszych, lista.Count - Parametry.Pierwszych);
                    break;
            }
            Grid.DataSource = lista;

            WliczacKWPZSection.Visible = Parametry.WliczKWPZ;
			sIgnorujZaliczkowe.Visible = Parametry.IgnorujZaliczkowe;
        }

        void LoadKWPZ( Dictionary<Kontrahent, Total> result )
        {
            var hm = HandelModule.GetInstance(dc);
            var magazyn = (Soneta.Magazyny.Magazyn)dc[typeof(Soneta.Magazyny.Magazyn)];
            var pars = (Soneta.Handel.Forms.DokHandloweViewInfo.WParams)
                dc[typeof(Soneta.Handel.Forms.DokHandloweViewInfo.WParams)];
            var vw = new SubTable(
                magazyn == null ? hm.DokHandlowe.WgDaty : hm.DokHandlowe.WgMagazyn[magazyn] as SubTable,
                pars.Okres).CreateView();
            vw.Condition &= new RowCondition.And(
                new FieldCondition.Equal("Definicja", hm.DefDokHandlowych.KorektaPZWZ),
                new FieldCondition.NotEqual("Stan", StanDokumentuHandlowego.Anulowany));
            if (pars.Kontrahent != null)
            {
                vw.Condition &= new FieldCondition.Equal("Kontrahent", pars.Kontrahent);				
            }

            vw.FilterCondition += (_, e) => e.Accepted &= Filter2((DokumentHandlowy) e.Row);

            foreach (DokumentHandlowy i in vw)
            {
                Total t;
                if (!result.TryGetValue( i.Kontrahent, out t ))
                {
                    t = new Total( i.Kontrahent );
                    result.Add( t.Kontrahent, t );
                }

                t.AddKwpz( i );
            }
        }
    
    static bool Filter2(DokumentHandlowy dok)
    {
        foreach (DokumentHandlowy wz in dok.Nadrzędne)
        {
            if (wz.Definicja == dok.Module.DefDokHandlowych.KorektaPZWZ)
            {
                if (Filter2(wz)) return true;
            }
            else if (wz.KierunekMagazynu == KierunekPartii.Rozchód)
            {
                if ((KategoriaHandlowa.HandelPierwszy <= wz.Kategoria && wz.Kategoria <= KategoriaHandlowa.HandelOstatni) || wz.DokumentyHandlowe.Length > 0) return true;
            }
        }
        
        return false;
    }

</script>

<body>
    <form id="Form1" method="post" runat="server">
        <ea:DataContext ID="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
        <eb:ReportHeader ID="ReportHeader" Title="Raport marży wg kontrahentów|</STRONG>Okres:<STRONG> {2}|</STRONG>Magazyn:<STRONG> {3}</STRONG>"
            runat="server" DataMember3="DokHandloweViewInfo+WParams.Magazyn" DataMember2="DokHandloweViewInfo+WParams.Okres">
        </eb:ReportHeader>
		<font face="Verdana" size="2">Raport nie uwzględnia duplikatów.</font>
		<br />
		<ea:Section runat="server" ID="sIgnorujZaliczkowe">
			<font face="Verdana" size="2">Raport nie uwzględnia faktur zaliczkowych.</font>
			<br />
		</ea:Section>
        <font face="Verdana" size="2">Raport uwzględnia korekty kosztu (KWPZ).</font>
		<br />
        <ea:Grid ID="Grid" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
            FooterBorder="Single" ShowSum="MoreThenOne">
            <Columns>
                <ea:GridColumn ID="GridColumn1" Width="4" Align="Right" DataMember="#" Caption="LP."
                    runat="server">
                </ea:GridColumn>
                <ea:GridColumn ID="GridColumn2" runat="server" Caption="Kod" DataMember="Kontrahent.Kod" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn ID="GridColumn8" DataMember="Kontrahent.Nazwa" runat="server" Caption="Kontrahent" Total="Info" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn ID="zakup" Width="13" Align="Right" Caption="Wartość~Zakupu" runat="server"
                    DataMember="ZNetto" Total="Sum" Format="{0:n}">
                </ea:GridColumn>
                <ea:GridColumn ID="sprzedaz" Width="13" Align="Right" Caption="Wartość~Sprzedaży" runat="server"
                    DataMember="SNetto" Format="{0:n}" Total="Sum">
                </ea:GridColumn>
                <ea:GridColumn ID="zysk" Width="13" Align="Right" Caption="Wartość~Marża"
                    runat="server" DataMember="Zysk" Format="{0:n}" Total="Sum">
                </ea:GridColumn>
                <ea:GridColumn ID="narzut" Width="10" Align="Right" Caption="Narzut %" runat="server"
                    DataMember="NarzutProc">
                </ea:GridColumn>
                <ea:GridColumn ID="marza" Width="10" Align="Right" Caption="Marża %" runat="server"
                    DataMember="MarzaProc">
                </ea:GridColumn>
            </Columns>
        </ea:Grid>
       <ea:Section ID="WliczacKWPZSection" runat="server" Width="100%" >
			<font face="Verdana" size="2">Dokumenty korekty kosztu KWPZ wliczone w wynik kontrahenta.</font>
			<br />
			<br />
       </ea:Section>
        <eb:ReportFooter ID="ReportFooter" runat="server" TheEnd="False">
        </eb:ReportFooter>
    </form>
</body>
</html>

